unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, Forms, Dialogs,
  StdCtrls, FileCtrl, Menus, ExtCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    OpenDialog1: TOpenDialog;
    Label1: TLabel;
    GroupBox1: TGroupBox;
    ListBox1: TListBox;
    ProgressBar1: TProgressBar;
    ComboBox1: TComboBox;
    GroupBox3: TGroupBox;
    Label3: TLabel;
    Edit1: TEdit;
    Button2: TButton;
    Label4: TLabel;
    Label5: TLabel;
    StaticText3: TStaticText;
    Label6: TLabel;
    StaticText4: TStaticText;
    Label7: TLabel;
    StaticText5: TStaticText;
    CheckBox1: TCheckBox;
    Button1: TButton;
    Button3: TButton;
    Timer1: TTimer;
    Memo1: TMemo;
    procedure Exit1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    function CheckID(FName: STRING): Boolean;
    function ArrToStr(c: ARRAY OF Char): STRING;
    function LastPos(c: Char; s: STRING): LongInt;
    procedure AddExtention(IName: STRING);
    procedure ComboBox1Change(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure RefreshOptions;
    procedure Timer1Timer(Sender: TObject);
    procedure AddHint(HintText: STRING; New: Boolean);
    procedure Button3Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure ShowAbout(s1,s2,s3,s4,s5,s6: STRING);
    function CheckArrays(Arr1,Arr2: ARRAY OF Byte): Boolean;
  private
    { Private declarations }
  public
    { Public declarations }
  end;
const
  id1=$00000014;
  id2=$33464650;
  id3:ARRAY[1..7]OF Byte=($1C,$00,$00,$00,$50,$57,$46);
  SELDIRHELP = 1000;
  DFVersion12=1;
  DFVersion3=2;
  AppName='Delta Force PFF,PWF Extractor';
  AppVersion='v1.0 beta';
  AppDate='4  2001';
  AppAuthor=' ';
  AppEMail='termius@aport2000.ru';
  AppHTTP='termius.chat.ru';
var
//  zzz: LongInt;
  DFVersion: Byte;
  SpaceNeeded: LongInt;
  Form1: TForm1;
  FATPos,FTotal: LongInt;
  OutputDirectory: STRING;
  FATSize: ARRAY[1..2]OF Byte;
  FRec: ARRAY[1..6000]OF RECORD
                           H1: ARRAY[1..4]OF Char;
                           FO: LongInt;
                           FL: LongInt;
                           H2: ARRAY[1..4]OF Char;
                           FN: ARRAY[1..24]OF Char;
                         END;
{  FRec: ARRAY[1..6000]OF RECORD
                           H1: ARRAY[1..4]OF Char;
                           FO: LongInt;
                           FL: LongInt;
                           H2: ARRAY[1..4]OF Char;
                           FN: ARRAY[1..16]OF Char;
                           H3: ARRAY[1..4]OF Char;
                         END;}

implementation

uses OpenDirDialog, error, About;

{$R *.DFM}
function TForm1.CheckArrays(Arr1,Arr2: ARRAY OF Byte): Boolean;
var
  i: Byte;
begin
  CheckArrays:=True;
  if Length(Arr1)<>Length(Arr2)then CheckArrays:=False else
  for i:=1 TO Length(Arr1) DO
  if not(Arr1[i-1]=Arr2[i-1])then CheckArrays:=False;
end;
procedure TForm1.ShowAbout(s1,s2,s3,s4,s5,s6: STRING);
begin
  Form3.StaticText1.Caption:=s1;
  Form3.StaticText2.Caption:=s2;
  Form3.StaticText3.Caption:=s3;
  Form3.StaticText4.Caption:=s4;
  Form3.StaticText5.Caption:=s5;
  Form3.StaticText6.Caption:=s6;
  Form3.ShowModal;
end;
function TForm1.LastPos(c: Char; s: STRING): LongInt;
var
  i,T: LongInt;
begin
  T:=0;
  if Length(s)=0 then Exit;
  for i:=1 to Length(s) do if s[i]=c then T:=i;
  LastPos:=T;
end;
procedure TForm1.AddHint(HintText: STRING; New: Boolean);
begin
  IF New THEN Memo1.Lines.Add(HintText)
    ELSE Memo1.Lines.Strings[Memo1.Lines.Count-1]:=Memo1.Lines.Strings[Memo1.Lines.Count-1]+HintText;
  if Memo1.Lines.Count>8 then Memo1.Lines.Delete(0);
end;
procedure TForm1.RefreshOptions;
begin
  StaticText3.Caption:=ComboBox1.Text;
  StaticText4.Caption:=IntToStr(ListBox1.Items.Count);
  StaticText5.Caption:=IntToStr(SpaceNeeded);
end;
procedure TForm1.AddExtention(IName: STRING);
var
  i: LongInt;
  Found: Boolean;
begin
  Found:=False;
  for i:=0 to ListBox1.Items.Count-1 do
  begin
    if (Pos('.',IName)=0)or(Copy(ComboBox1.Items.Strings[i],Pos('.',ComboBox1.Items.Strings[i])+1,3)=Copy(IName,Pos('.',IName)+1,3))then
    begin
      Found:=True;
      Break;
    end;
  end;
  IF NOT Found THEN ComboBox1.Items.Add('*.'+Copy(IName,Pos('.',IName)+1,3));
end;
function TForm1.ArrToStr(c: ARRAY OF Char): STRING;
var
  TStr: STRING;
  i: LongInt;
begin
  TStr:='';
  if Length(c)=0 then
  begin
    ArrToStr:='';
    Exit;
  end;
  if Pos(#00,c)=0 then
  begin
    ArrToStr:=c;
    Exit;
  end;
  for i:=1 to Length(c) do
  begin
    if Ord(c[i])>0 then TStr:=TStr+c[i];
  end;
  ArrToStr:=TStr;
end;
function TForm1.CheckID(FName: STRING): Boolean;
var
  Tid1,Tid2,TFATPos,TFTotal: LongInt;
  Tid3: ARRAY[1..7]OF Byte;
  F: FILE;
begin
  AssignFile(F,FName);
  Reset(F,1);
  BlockRead(F,Tid3,7);
  if CheckArrays(Tid3,id3) then
  begin
    DFVersion:=3;
    CheckID:=True;
    Exit;
  end;
  Seek(F,$00);
  BlockRead(F,Tid1,4);
  BlockRead(F,Tid2,4);
  IF NOT((Tid1=id1)AND(Tid2=id2))THEN CheckID:=False else
  begin
    BlockRead(F,TFTotal,4);
    Seek(F,$10);
    BlockRead(F,TFATPos,4);
    CASE((FileSize(F)-TFATPos-12)div TFTotal)OF
        36:begin DFVersion:=2; CheckID:=True; end;
        32:begin DFVersion:=1; CheckID:=True; end;
        ELSE CheckID:=False;
    END;
  end;
  CloseFile(F);
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Open1Click(Sender: TObject);
var
  FName: STRING;
  IName: STRING;
  F: FILE;
  i: LongInt;
begin
  IF NOT OpenDialog1.Execute THEN Exit;
  FName:=OpenDialog1.FileName;
  AddHint(' : "'+Copy(FName,LastPos('\',FName)+1,32)+'"',True);
  AddHint(' ...',True);
  IF NOT CheckID(FName)THEN
  BEGIN
    AddHint(':  !',False);
    Exit;
  END;
  case DFVersion of
    1:AddHint('  PFF (DF 1,2)',False);
    2:AddHint('  PFF (DF 3)',False);
    3:AddHint('  PWF (DF 1,2,3)',False);
  end;
  AssignFile(F,FName);
  Reset(F,1);
  Seek(F,$08);
  BlockRead(F,FTotal,4);
  Seek(F,$10);
  BlockRead(F,FATPos,4);
  AddHint('  ...',True);
  if DFVersion<3 then
  IF Round(Int((FileSize(F)-FATPos)/FATSize[DFVersion]))<>FTotal THEN
  BEGIN
    AddHint(':    !',False);
    Exit
  END;
  AddHint('Ok',False);
  case dfVersion of
    1:Seek(F,FATPos);
    2:Seek(F,FATPos);
    3:Seek(F,$1C);
  end;
  ListBox1.Items.Clear;
  ComboBox1.Items.Clear;
  ComboBox1.Items.Add('*.*');
  ComboBox1.ItemIndex:=0;
  AddHint(' ...',True);
  SpaceNeeded:=0;
  Form1.Refresh;
  if (DFVersion=1)or(DFVersion=2)then
  FOR i:=1 TO FTotal DO
  BEGIN
    BlockRead(F,FRec[i].H1,4);
    BlockRead(F,FRec[i].FO,4);
    BlockRead(F,FRec[i].FL,4);
    BlockRead(F,FRec[i].H2,4);
    case DFVersion of
      1:BlockRead(F,FRec[i].FN,16);
      2:BlockRead(F,FRec[i].FN,20);
      3:BlockRead(F,FRec[i].FN,24);
    end;
    IName:=ArrToStr(FRec[i].FN);
    ListBox1.Items.Add(IName);
    SpaceNeeded:=SpaceNeeded+FRec[i].FL;
    ProgressBar1.Position:=Round(100*(i/FTotal));
    AddExtention(IName);
  END else
  FOR i:=1 TO FTotal DO
  BEGIN
    BlockRead(F,FRec[i].FN,24);
    BlockRead(F,FRec[i].FO,4);
    BlockRead(F,FRec[i].FL,4);
    BlockRead(F,FRec[i].H1,4);
    BlockRead(F,FRec[i].H1,4);
    BlockRead(F,FRec[i].H1,4);
    BlockRead(F,FRec[i].H1,4);
    BlockRead(F,FRec[i].H1,4);
    IName:=ArrToStr(FRec[i].FN);
    ListBox1.Items.Add(IName);
    SpaceNeeded:=SpaceNeeded+FRec[i].FL;
    ProgressBar1.Position:=Round(100*(i/FTotal));
    AddExtention(IName);
  END;
  AddHint('Ok.  '+IntToStr(FTotal)+' .',False);
  CloseFile(F);
  RefreshOptions;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
var
  i: LongInt;
  TStr: STRING;
begin
  ListBox1.Items.Clear;
  TStr:=ComboBox1.Items.Strings[ComboBox1.ItemIndex];
  AddHint(' ...',True);
  SpaceNeeded:=0;
  if ComboBox1.ItemIndex=0 THEN
  begin
    for i:=1 to FTotal do
    begin
      ListBox1.Items.Add(ArrToStr(FRec[i].FN));
      ProgressBar1.Position:=Round(100*(i/FTotal));
      SpaceNeeded:=SpaceNeeded+FRec[i].FL;
    end;
    AddHint('Ok',False);
    RefreshOptions;
    Exit;
  end;
  for i:=1 to FTotal do
  begin
    if Pos(Copy(TStr,2,3),FRec[i].FN)>0 THEN
    begin
      ListBox1.Items.Add(ArrToStr(FRec[i].FN));
      SpaceNeeded:=SpaceNeeded+FRec[i].FL;
    end;
    ProgressBar1.Position:=Round(100*(i/FTotal));
  end;
  AddHint('Ok',False);
  RefreshOptions;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  TDir: STRING;
begin
  IF SelectDirectory('   ',Copy(OutputDirectory,1,3),TDir) then
  begin
    OutputDirectory:=TDir;
    AddHint('  .',True);
  end;
  Edit1.Text:=OutputDirectory;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  GetDir(0,OutputDirectory);
  Edit1.Text:=OutputDirectory;
  FATSize[1]:=32;
  FATSize[2]:=36;
  AddHint(' .',True);
  Form1.Caption:=AppName;
  Application.title:=AppName;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  case CheckBox1.Checked of
    True: CheckBox1.Caption:='';
   False: CheckBox1.Caption:='';
  end;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  IF ListBox1.SelCount>0 THEN Button1.Enabled:=True ELSE Button1.Enabled:=False;
  IF ListBox1.Items.Count>0 THEN Button3.Enabled:=True ELSE Button3.Enabled:=False;
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  Buff: ARRAY[1..300000]OF Char;
  F,FO: FILE;
  i,j: LongInt;
begin
  AddHint(' ...',True);
  AssignFile(F,OpenDialog1.FileName);
  Reset(F,1);
  for i:=1 to FTotal do
  begin
    if Pos('.',FRec[i].FN)>0 then
    if CheckBox1.Checked then
    ForceDirectories(OutputDirectory+'\'+Copy(FRec[i].FN,Pos('.',FRec[i].FN)+1,Pos(#00,FRec[i].FN)-Pos('.',FRec[i].FN)-1));
    if Pos('.',FRec[i].FN)>0 then
    if CheckBox1.Checked then
    AssignFile(FO,OutputDirectory+'\'+Copy(FRec[i].FN,Pos('.',FRec[i].FN)+1,Pos(#00,FRec[i].FN)-Pos('.',FRec[i].FN)-1)+'\'+FRec[i].FN) else
    AssignFile(FO,OutputDirectory+'\'+FRec[i].FN);
    ReWrite(FO,1);
    Seek(F,FRec[i].FO);
    if FRec[i].FL<=300000 then
    begin
      BlockRead(F,Buff,FRec[i].FL);
      BlockWrite(FO,Buff,FRec[i].FL);
    end else
    begin
      for j:=1 to (FRec[i].FL div 300000) do
      begin
        BlockRead(F,Buff,300000);
        BlockWrite(FO,Buff,300000);
      end;
      BlockRead(F,Buff,FRec[i].FL-300000*(FRec[i].FL div 300000));
      BlockWrite(FO,Buff,FRec[i].FL-300000*(FRec[i].FL div 300000));
    end;
    CloseFile(FO);
    ProgressBar1.Position:=Round(100*(i/FTotal));
  end;
  AddHint('Ok',False);
  CloseFile(F);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  MessageDLG('    !',mtError,[mbOk],0);
end;

procedure TForm1.About1Click(Sender: TObject);
begin
  ShowAbout(AppName,AppVersion,AppDate,AppAuthor,AppEMail,AppHTTP);
end;

end.
